import os
import random
import numpy as np  
import torch
import json
from transformers import AutoTokenizer, AutoModelForCausalLM, GPTJForCausalLM, OPTForCausalLM, GPTNeoXForCausalLM

def seed_everything(seed):
    random.seed(seed)
    os.environ['PYTHONASSEED'] = str(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = True

  
"""code for loading and data for samia"""
def load_jsonl(path):
    with open(path, "r") as f:
        lines = [json.loads(l) for l in f.readlines()]
        return lines

def add_jsonl(new_line, path):
    with open(path, "a") as f:
        json.dump(new_line, f)
        f.write("\n")

model_path_config = {"Llama-2-7b": "/mnt/sharedata/ssd/users/zhanghx/models/llama-2-7b-hf"}
def load_model(name, gpu):
    if name == "gpt-j-6B":
        model = GPTJForCausalLM.from_pretrained(
            "EleutherAI/gpt-j-6B",
            revision="float16",
            torch_dtype=torch.float16,
            cache_dir="../cache/gpt-j-6B",
        ).to(gpu)
        tokenizer = AutoTokenizer.from_pretrained(
            "EleutherAI/gpt-j-6B",
            cache_dir="../cache/gpt-j-6B",
        )

    elif name == "Llama-2-7b":
        model = AutoModelForCausalLM.from_pretrained(
            model_path_config[name],
            torch_dtype=torch.float16,
            cache_dir="../cache/Llama-2-7b-hf",
        ).to(gpu)
        tokenizer = AutoTokenizer.from_pretrained(
            model_path_config[name],
            cache_dir="../cache/Llama-2-7b-hf",
        )
        model.bfloat16()
    
    elif name == "opt-6.7b":
        model = OPTForCausalLM.from_pretrained(
            "facebook/opt-6.7b",
            torch_dtype=torch.float16,
            cache_dir="../cache/opt-6.7b",
        ).to(gpu)
        tokenizer = AutoTokenizer.from_pretrained(
            "facebook/opt-6.7b",
            cache_dir="../cache/opt-6.7b",
        )

    elif name == "pythia-6.9b":
        model = GPTNeoXForCausalLM.from_pretrained(
            "EleutherAI/pythia-6.9b-v0",
            torch_dtype=torch.float16,
            revision="step143000",
            cache_dir="../cache/pythia-6.9b-v0/step143000",
        ).to(gpu)
        tokenizer = AutoTokenizer.from_pretrained(
            "EleutherAI/pythia-6.9b-v0",
            revision="step143000",
            cache_dir="../cache/pythia-6.9b-v0/step143000",
        )
    
    return model, tokenizer